<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Donation Receipt</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }
        .receipt {
            width:calc(100% - 50px);
            margin: auto;
            border: 2px solid #ff4500;
            padding: 20px;
            background-image: url('<?php echo e(public_path('images/RVJP-pdg-bg-v2.png')); ?>');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        .receipt-stamp {
            width:calc(100% - 50px);
            margin: auto;
            border: 2px solid #ff4500;
            padding: 20px;
            background-size: cover;
        }

        .header {
            text-align: center;
            font-size: 1px;
            font-weight: bold;
            color: #ff4500;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .datatable td {
            padding: 10px;
            border: 1px solid #CCC;
        }
        .footer {
            font-size: 12px;
            color: #333;
            margin-top: 20px;
            text-align: center;
        }
        .rupees-sym{
            font-family: DejaVu Sans; sans-serif;
            background: #ff4500;
            color: #FFF;
            border: 1px solid #ff4500;
            width: 40px;
            height: 40px;
            text-align: center;
            display: inline-block;
            font-size: 26px;
            line-height: 30px;
            vertical-align: top;
            color: #ffffff;
        }
        .amount{
            background: #ffffff;
            border: 1px solid #CCC;
            width: 200px;
            height: 40px;
            font-weight: 700;
            text-align: left;
            display: inline-block;
            text-align: left;
            padding: 0px 10px;
            line-height: 30px;
            vertical-align: top;
            margin-left: -4px;
        }
    </style>
</head>
<body>
    <div class="receipt">
        
        <table style="border-bottom: 1px solid #ff4500;">
            <tr>
                <td style="text-align: center; margin-right: 10px;">
                    <img src="images/<?php echo e($party_type); ?>-small.png" alt="" style="max-width: 150px;">
                </td>
                <td style="padding-left: 10px;">
                    <h1 style="color: #ff4500; font-weight: bold; font-size:25px;"><?php echo e($party_type == 'UECT' ? 'AKHAND BHARAT RASTRIYA SANGH' : 'RASHTRIYA VIKASWADI JANTA PARTY'); ?></h1>
                    <p>Registration No. 56/201/2016-17/PPS-I <br> PAN No. AADAR0725R</p>
                    <p>Village & Post-Hariharpur Raikwari, District-Bahraich, Uttar Pradesh-271870</p>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    &nbsp;
                </td>
            </tr>
        </table>
        <table>
            <tr>
                <td>
                    &nbsp;
                </td>
            </tr>
        </table>
        <table class="datatable">
            <tr>
                <td>Receipt No.</td>
                <td colspan="3"><strong><?php echo e($receipt_no ?? ''); ?></strong></td>
                <td style="text-align: right;">Date:</td>
                <td><strong><?php echo e($created_at ?? ''); ?></strong></td>
            </tr>
            <tr>
                <td>Received with thanks M/s./Mrs./Mr.:</td>
                <td colspan="5"><strong><?php echo e(strtoupper($name) ?? ''); ?></strong></td>
            </tr>
            <tr>
                <td>PAN No.:</td>
                <td colspan="5"><strong><?php echo e(strtoupper($pan_no) ?? ''); ?></strong></td>
            </tr>
            <tr>
                <td>Address:</td>
                <td colspan="5"><strong><?php echo e(strtoupper($address) ?? ''); ?></strong></td>
            </tr>
            <tr>
                <td>Towards ELECTION FUND by <?php echo e($payment_mode === 'RTGS' ? 'RTGS' : ($payment_mode === 'IMPS' ? 'IMPS' : 'Cheque/D.D. No.')); ?></td>
                <td colspan="5"><strong><?php echo e(($payment_mode === 'RTGS' || $payment_mode === 'IMPS') ? $reference_no : $cheque_dd_no); ?></strong></td>
            </tr>
            <tr>
                <td>Date:</td>
                <td colspan="3"><strong><?php echo e($drawn_on ?? ''); ?></strong></td>
                <td style="text-align: right" >Bank:</td>
                <td><strong><?php echo e(strtoupper($branch) ?? ''); ?></strong></td>
            </tr>
            <tr>
                <td>Rupees:</td>
                <td colspan="5"><strong><?php echo e(strtoupper($amount_in_words) ?? ''); ?></strong></td>
            </tr>
        </table>
        <table>
            <tr>
                <td>
                    <span class="rupees-sym">&#8377;</span>

                    <span class="amount"><strong><?php echo e($amount ?? ''); ?></strong></span>
                </td>
                <td align="right">
                    <img src="images/RVJP-Stamp-Blue.png" alt="" style="max-width: 100px;">
                </td>
            </tr>
        </table>
        <div class="footer">
            <p>This Donation is Eligible for Exemption Under Income Tax Act 1961 U/S80 GGC/B.</p>
            <p>For, <?php echo e($party_type == 'UECT' ? 'AKHAND BHARAT RASTRIYA SANGH' : 'RASHTRIYA VIKASWADI JANTA PARTY'); ?></p>
            <p>This is a system-generated receipt and does not require a signature.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/cwsweblab/public_html/rvjp.cwsweblab.com/resources/views/admin/donation/rjvp-receipt.blade.php ENDPATH**/ ?>