

<!DOCTYPE html>
<html>
<head>
    <title>Donations Listing</title>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
</head>
<body>
    <a href="<?php echo e(route('admin.customers.create')); ?>" class="btn btn-success">Add Donation</a>
    <table id="donations-table" class="display">
        <thead>
            <tr>
                <th>Receipt No</th>
                <th>Name</th>
                <th>PAN No</th>
                <th>Address</th>
                <th>Amount</th>
                <th>Actions</th>
            </tr>
        </thead>
    </table>

    <script>
        $(document).ready(function () {
            $('#donations-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "<?php echo e(route('admin.customers.data')); ?>",
                columns: [
                    { data: 'receipt_no', name: 'receipt_no' },
                    { data: 'name', name: 'name' },
                    { data: 'pan_no', name: 'pan_no' },
                    { data: 'address', name: 'address' },
                    { data: 'amount', name: 'amount' },
                    { data: 'actions', name: 'actions', orderable: false, searchable: false }
                ],
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });
    </script>
</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/CarsSeva_old/resources/views/admin/layouts/layout.blade.php ENDPATH**/ ?>