@include('admin.donation.layouts.head')
<body>
    @include('admin.donation.layouts.header')
    <div class="main-container">
        @yield('content')
    </div>

    @include('admin.donation.layouts.footer')
    @include('admin.donation.layouts.alert')

    <div class="container">
        <div class="d-flex"></div>
        <h1>Add Donor</h1>
        <a href="{{ route('admin.donation.index') }}" class="btn btn-secondary mb-3">Back</a>
        <form action="{{ route('admin.donation.store') }}" method="POST" class="add-donations">
            @csrf
            <div class="mb-3">
                <label for="drawn_on" class="form-label">Receipt Date*</label>
                <input type="date" id="receipt_date" name="receipt_date" class="form-control" value="{{ old('receipt_date') }}">
                @error('receipt_date')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>
            
            <div class="mb-3">
                <label for="party_type" class="form-label">Select Party</label>
                <select id="party_type" name="party_type" class="form-control">
                    <option value="RVJP" {{ old('party_type') == 'RVJP' ? 'selected': '' }}>RVJP</option>
                    <option value="UECT" {{ old('party_type') == 'UECT' ? 'selected': '' }}>UECT</option>
                </select>
            </div>

            <div class="mb-3">
                <label for="name" class="form-label">Name*</label>
                <input type="text" id="name" name="name" class="form-control" value="{{ old('name') }}">
                @error('name')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="mb-3">
                <label for="pan_no" class="form-label">PAN No*</label>
                <input type="text" id="pan_no" name="pan_no" class="form-control" value="{{ old('pan_no') }}">
                @error('pan_no')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="mb-3">
                <label for="address" class="form-label">Address*</label>
                <textarea type="text" id="address" name="address" class="form-control" rows="3">{{ old('address') }}</textarea>
                @error('address')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="mb-3">
                <label for="payment_mode" class="form-label">Payment Mode</label>
                <select id="payment_mode" name="payment_mode" class="form-control" onchange="handleSelectionChange(event)">
                    <option value="" >Select Payment Type</option>
                    <option value="Cheque" {{ old('payment_mode') == 'Cheque' ? 'selected' : '' }}>Cheque</option>
                    <option value="DD" {{ old('payment_mode') == 'DD' ? 'selected' : '' }}>Demand Draft</option>
                    <option value="RTGS" {{ old('payment_mode') == 'RTGS' ? 'selected' : '' }}>RTGS</option>
                    <option value="IMPS" {{ old('payment_mode') == 'IMPS' ? 'selected' : '' }}>IMPS</option>
                    <option value="Cash" {{ old('payment_mode') == 'Cash' ? 'selected' : '' }}>Cash</option>
                </select>
            </div>

            <div class="mb-3 hidden-element for_cheque_dd_no {{old('payment_mode') == 'Cash' || old('payment_mode') == 'RTGS' || old('payment_mode') == 'IMPS' ? 'd-none' : ''}}" >
                <label for="cheque_dd_no" class="form-label">Cheque/DD No*</label>
                <input type="text" id="cheque_dd_no" name="cheque_dd_no" class="form-control" value="{{ old('cheque_dd_no') }}">
                @error('cheque_dd_no')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="mb-3 hidden-element for_reference_no {{old('payment_mode') == 'Cash' || old('payment_mode') == 'Cheque' || old('payment_mode') == 'DD' ? 'd-none' : ''}}" >
                <label for="reference_no" class="form-label">Reference No*</label>
                <input type="text" id="reference_no" name="reference_no" class="form-control" value="{{ old('reference_no') }}">
                @error('reference_no')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="mb-3 hidden-element {{old('payment_mode') == 'Cash' ? 'd-none' : ''}}">
                <label for="drawn_on" class="form-label">Drawn On*</label>
                <input type="date" id="drawn_on" name="drawn_on" class="form-control" value="{{ old('drawn_on') }}">
                @error('drawn_on')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="mb-3 hidden-element {{old('payment_mode') == 'Cash' ? 'd-none' : ''}}">
                <label for="branch" class="form-label">Branch*</label>
                <input type="text" id="branch" name="branch" class="form-control" value="{{ old('branch') }}">
                @error('branch')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="mb-3">
                <label for="amount" class="form-label">Amount*</label>
                <input type="number" step="0.01" id="amount" name="amount" class="form-control" value="{{ old('amount') }}">
                @error('amount')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <button type="submit" class="btn btn-primary">Submit</button>
        </form>
    </div>
</body>
