<html>
@section('title', 'Login')
@include('admin.layouts.head')

<body>
    <div class="login-bg">
        <div class="login-panel d-flex align-items-center">
            {{ Form::open(['route' => 'admin.login']) }}
            <div class="login-box">
                <div class="logo text-center"><img src="{{ asset('images/logo.png') }}"></div>
                <h1 class="mb-3">Sign In</h1>
                <div class="login-input">
                    <i class="far fa-envelope left" style="top: 16px"></i>
                    {{ Form::text('email', old('email'), ['class' => 'form-control', 'placeholder' => 'Email', 'required']) }}
                    @error('email')
                        <span class="invalid-feedback" role="alert" style="display: block">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>
                <div class="login-input">
                    <i class="fas fa-unlock-alt left"></i>
                    <i class="far fa-eye right" onclick="myFunction()"></i>
                    <input type="password" placeholder="Password" name="password" id="Password" required style="display: block">
                    @error('password')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </div>
                <div class="login-input">
                    <div class="custom-control custom-checkbox float-left">
                        <input type="checkbox" class="custom-control-input" name="remember" {{ old('remember') ? 'checked' : '' }} id="customCheck1">
                        <label class="custom-control-label pl-2" for="customCheck1">Remember me</label>
                    </div>
                    {{-- <a class="float-right" href="{{ route('admin.password.request') }}">Forgot Password?</a> --}}
                </div>
                <button type="submit" class="btn btn-primary btn-block">Sign In</button>
                <div class="copyright-text text-center">© 2025 Rashtriya Vikasvadi Janta Party.All Rights Reserved</div>
            </div>
            {{ Form::close() }}
        </div>
    </div>
    @include('admin.layouts.footer')
    <script type="text/javascript">
        function myFunction() {
          var x = document.getElementById("Password");
          if (x.type === "password") {
            x.type = "text";
          } else {
            x.type = "password";
          }
        }
    </script>
</body>

</html>
