@extends('admin.layouts.layout')
@section('content')
<div class="row">
    @include('admin.account.sidebar')
    <div class="col-xl-9 col-lg-9">

        <div class="white-box edit-view">
            <div class="row">
                <div class="col-xl-6">
                    {{ Form::open(['route' => 'admin.account.password.update', 'method' => 'POST']) }}
                    <div class="heading-border">
                        <h3>Change Password</h3>
                        <div class="float-right">
                            <button class="btn btn-primary" href="submit">Update</button>
                        </div>
                    </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="name">New Password<span>*</span></label>
                                {{ Form::password('password', ['class' => 'form-control', 'required']) }}
                                @error('password')
                                    <span class="danger" role="alert" >
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-6">
                                <label for="contact">Repeat Password<span>*</span></label>
                                {{ Form::password('password_confirmation', ['class' => 'form-control', 'required']) }}
                            </div>

                        </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
</div>
@stop