<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDonationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('donations', function (Blueprint $table) {
            $table->id();
            $table->enum('party_type', ['RVJP', 'ABRS']);
            $table->string('receipt_no');
            $table->string('name');
            $table->string('pan_no');
            $table->string('address');
            $table->string('payment_mode');
            $table->string('cheque_dd_no')->nullable();
            $table->string('drawn_on')->nullable();
            $table->string('branch')->nullable();
            $table->decimal('amount', 12, 2);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('donations');
    }
}
