<?php

namespace App\Rules;

use App\Helpers\ReceiptHelper;
use App\Models\Donation;
use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\Config;

class ReceiptNumber implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $prefix = Config::get('constants.prefix.receipt');
        $lastRcpt = Donation::select('receipt_no')->withTrashed()->orderBy('id', 'desc')->first();

        $latestReceiptNumber = '';
        if (isset($lastRcpt->receipt_no)) {
            $latestReceiptNumber = ReceiptHelper::increaseSeqNo($lastRcpt->receipt_no, $prefix);
        } else {
            $latestReceiptNumber = $prefix.'000001';
        }

        return $value == $latestReceiptNumber;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Invalid :attribute .';
    }
}
